class PrinterModel {
  final String? address;
  final String? vendorId;
  final int? id;
  final String? deviceName;
  final String? port;
  final int? typeIndex;

  PrinterModel({this.address, this.vendorId, this.id, this.deviceName, this.port,required this.typeIndex});

  factory PrinterModel.fromJson(Map<String, dynamic> json) {
    return PrinterModel(
      address: json['address'] as String?,
      vendorId: json['vendorId'] as String?,
      id: json['id'] as int?,
      deviceName: json['deviceName'] as String?,
      port: json['port'] as String?,
      typeIndex: json["typeIndex"] as int?
    );
  }

   Map<String, Object?> toJson() {
    return {
      'address': address,
      'vendorId': vendorId,
      'id': id,
      'deviceName': deviceName,
      'port': port,
      'typeIndex':typeIndex,
    };
  }
}
